%%%%%%%%%%%%%%%%
function Mp=apprepfn(X,pret1,mm,sm)
%Preprocessing routine. Performs mean centering ('mean'), autoscaling
%('auto') or no pretreatment ('none') - Using parameters computed on the
%training set

nt=size(X,1);
switch pret1
    case 'none'
        Mp=X;
    case 'mean'
        Mp=X-repmat(mm, nt, 1);
    case {'auto','pareto'}
        snzero=1:size(X,2);snzero(sm==0)=[];
        Mp=zeros(size(X));
        Mp(:,snzero)=(X(:,snzero)-repmat(mm(snzero), nt, 1))./repmat(sm(snzero),nt, 1);
end

